function [sys,x0,str,ts] = wait3(t,x,u,flag)
%DSFUNC An example M-file S-function for defining a discrete system.  
%   Example M-file S-function implementing discrete equations: 
%      x(n+1) = Ax(n) + Bu(n)
%      y(n)   = Cx(n) + Du(n)
%   
%   See sfuntmpl.m for a general S-function template.
%
%   See also SFUNTMPL.
    
%   Copyright (c) 1990-96 by The MathWorks, Inc.
%   $Revision: 1.11 $

% Generate a discrete linear system:
A=zeros(7);
A(7,7)=1;


B=zeros(7,2);

C=[0 0 0 0 0 0 1];

D=[1 0];

switch flag,

  %%%%%%%%%%%%%%%%%%
  % Initialization %
  %%%%%%%%%%%%%%%%%%
  case 0,
    [sys,x0,str,ts] = mdlInitializeSizes(A,B,C,D);

  %%%%%%%%%%
  % Update %
  %%%%%%%%%%
  case 2,                                                
    sys = mdlUpdate(t,x,u,A,B,C,D); 

  %%%%%%%%%%
  % Output %
  %%%%%%%%%%
  case 3,                                                
    sys = mdlOutputs(t,x,u,A,C,D);

  %%%%%%%%%%%%%
  % Terminate %
  %%%%%%%%%%%%%
  case 9,                                                
    sys = []; % do nothing

  %%%%%%%%%%%%%%%%%%%%
  % Unexpected flags %
  %%%%%%%%%%%%%%%%%%%%
  otherwise
    error(['unhandled flag = ',num2str(flag)]);
end

%end dsfunc

%
%=======================================================================
% mdlInitializeSizes
% Return the sizes, initial conditions, and sample times for the S-function.
%=======================================================================
%
function [sys,x0,str,ts] = mdlInitializeSizes(A,B,C,D)

sizes = simsizes;
sizes.NumContStates  = 0;
sizes.NumDiscStates  = size(A,1);
sizes.NumOutputs     = size(D,1);
sizes.NumInputs      = size(D,2);
sizes.DirFeedthrough = 1;
sizes.NumSampleTimes = 1;

sys = simsizes(sizes);

x0(1:6)  =clock ;
x0=x0';
x0(7)=0;

str = [];
ts  = [-1 0]; 

% end mdlInitializeSizes
%
%=======================================================================
% mdlUpdate
% Handle discrete state updates, sample time hits, and major time step
% requirements.
%=======================================================================
%
function sys = mdlUpdate(t,x,u,A,B,C,D)
%
 
% The above variable determines speed of execution
% set it to one for real time 
t0=x(1:6)';
speed=5;
while etime(clock,t0) < u(1)/speed;
end

sys(1:6)=clock;
sys=sys';
sys(7)=x(7)+u(1);


%end mdlUpdate
%
%=======================================================================
% mdlOutputs
% Return Return the output vector for the S-function
%=======================================================================
%
function sys = mdlOutputs(t,x,u,A,C,D)


sys = C*x+D*u;

%end mdlUpdate

